/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.Messages;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiffFormatter {
    private static final Pattern gitDiffHeaderRegexp = Pattern.compile("@@ \\-([0-9]+),?\\d* \\+(\\d+),?\\d* @@");

    public static String toHTML(String title, String diff) {
        if (diff == null) {
            return "";
        }
        return DiffFormatter.injectIntoTemplate(DiffFormatter.convertDiff(title, diff));
    }

    private static String convertDiff(String title, String diff) {
        if (title == null) {
            title = "";
        }
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"file\">");
        html.append("<div class=\"fileHeader\">").append(title).append("</div>");
        html.append("<div class=\"diffContent\">");
        if (!diff.startsWith("diff")) {
            if (diff.length() == 0) {
                diff = Messages.DiffFormatter_NoContent;
            }
            html.append("<pre>" + StringUtil.sanitizeHTML((String)diff) + "</pre>");
        } else {
            String[] lines = diff.split("\r\n|\r|\n");
            StringBuilder diffContent = new StringBuilder();
            StringBuilder line1 = new StringBuilder();
            StringBuilder line2 = new StringBuilder();
            String lineNumberNewline = "\n";
            if (Platform.getOS().equals("win32")) {
                lineNumberNewline = "<br />\n";
            }
            int hunkStartLine1 = 0;
            int hunkStartLine2 = 0;
            int i = 4;
            while (i < lines.length) {
                String line = lines[i];
                if (line != null && line.length() != 0) {
                    char c = line.charAt(0);
                    switch (c) {
                        case '@': {
                            Matcher m = gitDiffHeaderRegexp.matcher(line);
                            if (m.find()) {
                                hunkStartLine1 = Integer.parseInt(m.group(1)) - 1;
                                hunkStartLine2 = Integer.parseInt(m.group(2)) - 1;
                            }
                            line1.append("..").append(lineNumberNewline);
                            line2.append("..").append(lineNumberNewline);
                            diffContent.append("<div class=\"hunkheader\">").append(StringUtil.sanitizeHTML((String)line)).append("</div>");
                            break;
                        }
                        case '+': {
                            if (line.equals("+++ /dev/null")) break;
                            line = StringUtil.sanitizeHTML((String)line);
                            line = line.replaceFirst("\\s+$", "<span class=\"whitespace\">$0</span>");
                            line1.append(lineNumberNewline);
                            line2.append(++hunkStartLine2).append(lineNumberNewline);
                            diffContent.append("<div class=\"addline\">").append(line).append("</div>");
                            break;
                        }
                        case ' ': {
                            line1.append(++hunkStartLine1).append(lineNumberNewline);
                            line2.append(++hunkStartLine2).append(lineNumberNewline);
                            diffContent.append("<div class=\"noopline\">").append(StringUtil.sanitizeHTML((String)line)).append("</div>");
                            break;
                        }
                        case '-': {
                            line1.append(++hunkStartLine1).append(lineNumberNewline);
                            line2.append(lineNumberNewline);
                            diffContent.append("<div class=\"delline\">").append(StringUtil.sanitizeHTML((String)line)).append("</div>");
                            break;
                        }
                    }
                }
                ++i;
            }
            html.append("<div class=\"lineno\">").append((CharSequence)line1).append("</div>");
            html.append("<div class=\"lineno\">").append((CharSequence)line2).append("</div>");
            html.append("<div class=\"lines\">").append((CharSequence)diffContent).append("</div>");
        }
        html.append("</div>").append("</div>");
        return html.toString();
    }

    private static String injectIntoTemplate(String html) {
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)GitUIPlugin.getDefault().getBundle(), (IPath)new Path("templates").append("diff.html"), (boolean)false);
            String template = IOUtil.read((InputStream)stream);
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("\\{diff\\}", Matcher.quoteReplacement(html));
            return StringUtil.replaceAll((String)template, variables);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            return html;
        }
    }

    public static String toHTML(Map<IPath, String> diffs) {
        if (diffs == null) {
            return "";
        }
        StringBuilder combined = new StringBuilder();
        for (Map.Entry<IPath, String> diffMap : diffs.entrySet()) {
            combined.append(DiffFormatter.convertDiff(diffMap.getKey().toOSString(), diffMap.getValue())).append('\n');
        }
        return DiffFormatter.injectIntoTemplate(combined.toString());
    }
}

